% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Predicting.R
\name{Predicting}
\alias{Predicting}
\title{Predicting Class}
\description{
This class is designed for predictions.

The Predicting is structured as followed:
\itemize{
\item \link{PredictLayer}: Exists for each modality.
\itemize{
\item \link{PredictData}: Related class for modality-specific predictions.
}
\item \link{PredictMetaLayer}: Related class for meta predictions.
\itemize{
\item \link{PredictData}: Specific to the meta layer, it is set up internally after cross-validation.
}
}

Use the function \code{train} for training and \code{predict} for predicting.

TODO: Do not export me.
}
\seealso{
\link{TrainLayer}
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{Predicting}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Predicting-new}{\code{Predicting$new()}}
\item \href{#method-Predicting-print}{\code{Predicting$print()}}
\item \href{#method-Predicting-createMetaTestData}{\code{Predicting$createMetaTestData()}}
\item \href{#method-Predicting-getIndIDs}{\code{Predicting$getIndIDs()}}
\item \href{#method-Predicting-getPredictMetaLayer}{\code{Predicting$getPredictMetaLayer()}}
\item \href{#method-Predicting-getIndCol}{\code{Predicting$getIndCol()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Predicting-new"></a>}}
\if{latex}{\out{\hypertarget{method-Predicting-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Predicting$new(id, ind_col)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character}\cr
Predicting id.}

\item{\code{ind_col}}{\code{character}
Name of column of individuals IDS}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Predicting-print"></a>}}
\if{latex}{\out{\hypertarget{method-Predicting-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Predicting$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Predicting-createMetaTestData"></a>}}
\if{latex}{\out{\hypertarget{method-Predicting-createMetaTestData}{}}}
\subsection{Method \code{createMetaTestData()}}{
Creates a new modality-specific predictions dataset based on layer predictions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Predicting$createMetaTestData(meta_layer_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{meta_layer_id}}{(\code{character(1)}) \cr
ID of the meta layer where the testing meta data will be stored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{TestData} is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Predicting-getIndIDs"></a>}}
\if{latex}{\out{\hypertarget{method-Predicting-getIndIDs}{}}}
\subsection{Method \code{getIndIDs()}}{
Gather individual IDs from all layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Predicting$getIndIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Predicting-getPredictMetaLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Predicting-getPredictMetaLayer}{}}}
\subsection{Method \code{getPredictMetaLayer()}}{
Getter of the meta layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Predicting$getPredictMetaLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Object from class \link{PredictMetaLayer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Predicting-getIndCol"></a>}}
\if{latex}{\out{\hypertarget{method-Predicting-getIndCol}{}}}
\subsection{Method \code{getIndCol()}}{
Getter of the individual column name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Predicting$getIndCol()}\if{html}{\out{</div>}}
}

}
}
