% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontmatter-package.R
\docType{package}
\name{frontmatter-package}
\alias{frontmatter}
\alias{frontmatter-package}
\title{frontmatter: Parse Front Matter from Documents}
\description{
Extracts and parses YAML or TOML front matter from text documents.
Front matter is structured metadata at the beginning of a document,
delimited by fences.
}
\section{Supported Formats}{

\itemize{
\item Standard YAML (\verb{---} delimiters)
\item Standard TOML (\verb{+++} delimiters)
\item Comment-wrapped formats for R/Python files (\verb{#} and \verb{#'} prefixes)
\item PEP 723 Python inline script metadata
}
}

\section{Main Functions}{

\itemize{
\item \code{\link[=parse_front_matter]{parse_front_matter()}}: Parse front matter from a string
\item \code{\link[=read_front_matter]{read_front_matter()}}: Parse front matter from a file
}
}

\section{Performance}{

Uses C++11 for fast, single-pass parsing with minimal memory overhead.
Designed for high throughput processing of many documents.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/posit-dev/frontmatter}
  \item \url{https://posit-dev.github.io/frontmatter/}
  \item Report bugs at \url{https://github.com/posit-dev/frontmatter/issues}
}

}
\author{
\strong{Maintainer}: Garrick Aden-Buie \email{garrick@posit.co} (\href{https://orcid.org/0000-0002-7111-0077}{ORCID})

Other contributors:
\itemize{
  \item Posit Software, PBC (\href{https://ror.org/03wc8by49}{ROR}) [copyright holder, funder]
}

}
\keyword{internal}
