% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DW_Server.R
\name{DW_set_current_view}
\alias{DW_set_current_view}
\title{Sets Current Data View}
\usage{
DW_set_current_view(state, dw_view)
}
\arguments{
\item{state}{DW state from \code{DW_fetch_state()}}

\item{dw_view}{Data view list of the format returned from \code{DW_fetch_current_view()}
(see the structure of \code{state$DW$views} in the output of \code{DW_fetch_state()}).}
}
\value{
DW state object with the value of \code{dw_view} set to the current view id.
}
\description{
Takes a DW state and an updated view and sets that view to the
current view_id
}
\examples{
library(formods)
# The example requires a formods DW state object
state  = DW_test_mksession()$state
state[["DW"]][["ui"]][["select_dw_element"]]          = "filter"
state[["DW"]][["ui"]][["select_fds_filter_column"]]   = "EVID"
state[["DW"]][["ui"]][["select_fds_filter_operator"]] = "=="
state[["DW"]][["ui"]][["fds_filter_rhs"]]             = 0

# This builds the data wrangling statement based on
# elemets scraped from the UI
dwb_res  = dwrs_builder(state)

# Here we evaluate the resulting command:
dwee_res = dw_eval_element(state, dwb_res[["cmd"]])

# Next we add this wrangling element to the state
state    = DW_add_wrangling_element(state, dwb_res, dwee_res)

# This creates a new data view and makes it active
state = DW_new_view(state)

# Here we can pluck out that data view from the state
current_view = DW_fetch_current_view(state)

# This will update the key in this view
current_view[["key"]] = "My new view"

# And this will place it back into the state
state = DW_set_current_view(state, current_view)
}
