% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degraded_forest_grade.R
\name{calc_degraded_forest_grade}
\alias{calc_degraded_forest_grade}
\title{Calculating degraded forest grade}
\usage{
calc_degraded_forest_grade(plot_data)
}
\arguments{
\item{plot_data}{Preprocessed plot_data}
}
\value{
res_data with degraded forest grade
}
\description{
Calculation of degraded forest grade.
}
\details{
Calculation of degraded forest grade, icluding p1, p2,p3, p4, p5, p1m, p2m, p3m, p4m, Z1, Z2, Z3, Z4, Z5, Z, Z_weights, Z_grade, Z_weights_grade etc.
}
\examples{
\donttest{
# Load forest survey data
data(tree_1)
data(tree_2)
data(tree_3)
data(plot_1)
data(plot_2)
data(plot_3)

# Preprocess the degraded forest data
plot_data <- degraded_forest_preprocess(tree_1,tree_2,tree_3,plot_1,plot_2,plot_3)

# Calculation of degraded forest grade
res_data <- calc_degraded_forest_grade(plot_data)
}
}
