% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv-methods.R
\name{deriv.HRF}
\alias{deriv.HRF}
\alias{deriv.SPMG1_HRF}
\alias{deriv.SPMG2_HRF}
\alias{deriv.SPMG3_HRF}
\title{Default derivative method for HRF objects}
\usage{
\method{deriv}{HRF}(x, t, ...)

\method{deriv}{SPMG1_HRF}(x, t, ...)

\method{deriv}{SPMG2_HRF}(x, t, ...)

\method{deriv}{SPMG3_HRF}(x, t, ...)
}
\arguments{
\item{x}{An SPMG3_HRF object}

\item{t}{Numeric vector of time points at which to evaluate the derivative}

\item{...}{Additional arguments (currently unused)}
}
\value{
Numeric vector or matrix of derivative values

Numeric vector of derivative values

Matrix with 2 columns of derivative values

Matrix with 3 columns of derivative values
}
\description{
Uses numerical differentiation via numDeriv::grad when analytic derivatives
are not available for a specific HRF type.

Uses the analytic derivative formula for the SPM canonical HRF.

Returns derivatives for both the canonical HRF and its temporal derivative.
The first column contains the derivative of the canonical HRF, and the second
column contains the second derivative (derivative of the temporal derivative).

Returns derivatives for the canonical HRF and its two derivatives.
Since SPMG3 already includes first and second derivatives as basis functions,
this method returns their derivatives (1st, 2nd, and 3rd derivatives of the original HRF).
}
\examples{
t <- seq(0, 30, by = 0.5)
d <- deriv(HRF_SPMG1, t)
}
