% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowmapblue.R
\name{flowmapblue}
\alias{flowmapblue}
\title{Create an interactive flow map}
\usage{
flowmapblue(
  locations,
  flows,
  mapboxAccessToken = NULL,
  clustering = TRUE,
  animation = FALSE,
  darkMode = FALSE
)
}
\arguments{
\item{locations}{A \code{data.frame} containing the location data. The \code{data.frame} should have the following columns:
\describe{
\item{id}{A character vector representing the unique identifier for each location (e.g., "JU", "LU").}
\item{name}{(Optional) A character vector representing the name of each location (e.g., "Jura", "Luzern").}
\item{lat}{A numeric vector representing the latitude of each location in WGS84 (EPSG: 4326) coordinate reference system.}
\item{lon}{A numeric vector representing the longitude of each location in WGS84 (EPSG: 4326) coordinate reference system.}
}}

\item{flows}{A \code{data.frame} containing the flow data between locations. The \code{data.frame} should have the following columns:
\describe{
\item{origin}{A \code{character} vector representing the origin location identifier (must match the \code{id} in \code{locations}).}
\item{dest}{A \code{character} vector representing the destination location identifier (must match the \code{id} in \code{locations}).}
\item{count}{An \code{integer} vector representing the flow count between the origin and destination locations.}
\item{time}{(Optional) A vector of \code{POSIXct} or \code{Date} objects representing the date or date and time of the flow.}
}}

\item{mapboxAccessToken}{A \code{character} string representing the Mapbox access token. This is required to render the map using Mapbox tiles. You can obtain a free token at \href{https://account.mapbox.com/}{https://account.mapbox.com/}.}

\item{clustering}{A \code{logical} value indicating whether to enable clustering of locations on the map. Defaults to \code{TRUE}.}

\item{animation}{A \code{logical} value indicating whether to enable animation of flows on the map. Defaults to \code{FALSE}.}

\item{darkMode}{A \code{logical} value indicating whether to enable dark mode for the map. Defaults to \code{FALSE}.}
}
\value{
An HTML widget of class \code{flowmapblue} and \code{htmlwidget} that can be rendered in R Markdown, Shiny, or viewed in a browser. It can also be saved to \code{html} file with \code{\link[htmlwidgets:saveWidget]{htmlwidgets:saveWidget()}}. See examples for more details.
}
\description{
Creates an interactive flow map visualizing flows between various locations and outputs it as an HTML widget. This function utilizes the \href{https://www.flowmap.blue/}{\code{FlowmapBlue}} library to create maps with customizable options such as clustering, animation, and dark mode. The widget can be rendered in R Markdown, Shiny, or viewed in a browser. It can also be saved to \code{html} file with \code{\link[htmlwidgets:saveWidget]{htmlwidgets:saveWidget()}}. See examples for more details.
}
\examples{
\dontrun{
# example 1, normal flows
# set your Mapbox access token
Sys.setenv(MAPBOX_API_TOKEN = "YOUR_MAPBOX_ACCESS_TOKEN")

# load locations and flows for Switzerland
locations <- data(ch_locations)
flows <- data(ch_flows)

flowmap <- flowmapblue(
 locations,
 flows,
 mapboxAccessToken = Sys.getenv('MAPBOX_API_TOKEN'),
 clustering = TRUE,
 darkMode = TRUE,
 animation = FALSE
)

# view the map
flowmap

# or save it as an HTML file
htmlwidgets::saveWidget(flowmap, file = "flowmap.html")

# example 2, flows with date in time column
# set your Mapbox access token
Sys.setenv(MAPBOX_API_TOKEN = "YOUR_MAPBOX_ACCESS_TOKEN")

# load locations and flows for Switzerland
locations <- data(ch_locations)
flows <- data(ch_flows)

# generate fake datetime
flows$time <- seq(from =as.POSIXct("2020-01-01"),
  to = as.POSIXct("2020-01-05"), length.out = nrow(flows))

flowmap <- flowmapblue(
 locations,
 flows,
 mapboxAccessToken = Sys.getenv('MAPBOX_API_TOKEN'),
 clustering = TRUE,
 darkMode = TRUE,
 animation = FALSE
)

# view the map
flowmap

# example 3, flows with date in time column
# set your Mapbox access token
Sys.setenv(MAPBOX_API_TOKEN = "YOUR_MAPBOX_ACCESS_TOKEN")

# load locations and flows for Switzerland
locations <- data(ch_locations)
flows <- data(ch_flows)
# generate fake dates
flows$time <- seq(from = as.Date("2020-01-01"),
  to = as.Date("2020-06-01"), length.out = nrow(flows))

flowmap <- flowmapblue(
 locations,
 flows,
 mapboxAccessToken = Sys.getenv('MAPBOX_API_TOKEN'),
 clustering = TRUE,
 darkMode = TRUE,
 animation = FALSE
)

# view the map
flowmap
}

}
