% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_proxy.R
\name{ReverseProxy}
\alias{ReverseProxy}
\title{Fiery plugin for a single reverse proxy}
\description{
Fiery plugin for a single reverse proxy

Fiery plugin for a single reverse proxy
}
\details{
This plugin establishes a reverse proxy between the server and a target
origin server. It supports both HTTP and WebSocket connections and sets all
the relevant headers for tracking the request along the proxy chain.
}
\section{Initialization}{

A new 'ReverseProxy'-object is initialized using the \code{new()} method on
the generator:

\strong{Usage}
\tabular{l}{
\code{route <- ReverseProxy$new(target, root = "/", continue = FALSE, trust = FALSE)}
}
}

\examples{
# Create a reverse proxy forwarding requests to http://example.com
rev_prox <- ReverseProxy$new(
  "http://example.com"
)

# Use root to only proxy requests to a specific subpath
rev_prox <- ReverseProxy$new(
  "http://example.com",
  root = "forward"
)

# Use except to exempt certain subpaths from proxying
rev_prox <- ReverseProxy$new(
  "http://example.com",
  except = c("no_proxy", "dont/proxy")
)

## Attach it to a fiery app
if (requireNamespace("fiery", quietly = TRUE)) {
  app <- fiery::Fire$new()
  app$attach(rev_prox)
}

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{The name used by default for the plugin}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ReverseProxy-new}{\code{ReverseProxy$new()}}
\item \href{#method-ReverseProxy-on_attach}{\code{ReverseProxy$on_attach()}}
\item \href{#method-ReverseProxy-clone}{\code{ReverseProxy$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReverseProxy-new"></a>}}
\if{latex}{\out{\hypertarget{method-ReverseProxy-new}{}}}
\subsection{Method \code{new()}}{
Create a new reverse proxy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReverseProxy$new(target, root = "/", except = NULL, trust = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target}}{The URL to the origin server being proxied}

\item{\code{root}}{The root path the reverse proxy should respond to. Only
requests to subsets of the root path will be proxied, and the root will
be stripped from the URL path before being forwarded}

\item{\code{except}}{Subpaths to \code{root} that should be excempt from forwarding
to the target.}

\item{\code{trust}}{Are requests coming from a trusted source}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReverseProxy-on_attach"></a>}}
\if{latex}{\out{\hypertarget{method-ReverseProxy-on_attach}{}}}
\subsection{Method \code{on_attach()}}{
Hook for attaching the plugin to a fiery app. Should not be
called directly
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReverseProxy$on_attach(app, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{The fiery app to attach to}

\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReverseProxy-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ReverseProxy-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReverseProxy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
