% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.degree.constraint.R
\name{net.degree.constraint}
\alias{net.degree.constraint}
\title{Generate a degree-constraint graph}
\usage{
net.degree.constraint(DEG, c.alpha, c.min)
}
\arguments{
\item{DEG}{Degree sequence.}

\item{c.alpha}{Scaling parameter of the community-size distribution.}

\item{c.min}{Minimal size of a community.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Generate a degree-constraint graph.
}
\details{
The generated network has a pre-defined degree sequence with multiple (overlapping) communities.
}
\examples{
\dontrun{
DEG <- sample(seq(5,15),100, replace=TRUE)
x <- net.degree.constraint(DEG, c.alpha=2, c.min=3)}
}
\references{
Dong X, Castro L, Shaikh N (2020). “fastnet: An R Package for Fast Simulation and Analysis of Large-Scale Social Networks.” Journal of Statistical Software, 96(7), 1-23. doi:10.18637/jss.v096.i07 (URL: https://doi.org/10.18637/jss.v096.i07)
}
\author{
Xu Dong, Nazrul Shaikh
}
