% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef-liureg.R
\name{coef.liureg}
\alias{coef.liureg}
\title{Extract coefficient estimates from a liureg object}
\usage{
\method{coef}{liureg}(object, ...)
}
\arguments{
\item{object}{A \code{liureg} object.}

\item{...}{Not used in this implementation.}
}
\value{
The returned object is a data.frame containing the coefficients path.
}
\description{
Prints coefficient estimates from a
fitted \code{liureg} object.
}
\examples{
data("Hitters")
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.01)
liu.mod <- liureg(X, y, lam)
coef(liu.mod)
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=predict]{predict()}}, \code{\link[=summary]{summary()}}, \code{\link[=pressliu]{pressliu()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç
}
