% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.r
\name{hist,GRaster-method}
\alias{hist,GRaster-method}
\alias{hist}
\title{Plot a histogram of raster values}
\usage{
\S4method{hist}{GRaster}(x, layer, maxnl = 16, bins = 30, freq = TRUE, ...)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{layer}{Character, numeric, or integer: Indicates which layer of a multi-layer \code{GRaster} for which to plot a histogram. The layer can be identified using its \code{\link[terra:names]{terra::name()}} (character) or index (numeric or integer). If this is missing, then up to \code{maxnl} layers are plotted.}

\item{maxnl}{Maximum number of layers for which to create histograms. This is 16 by default, but ignored if \code{layer} is defined.}

\item{bins}{Positive numeric integer: Number of bins in which to divide values of a raster with continuous values. For \code{integer} and categorical rasters, each value is tallied.}

\item{freq}{Logical: If \code{TRUE} (default), plot the frequency of values. If \code{FALSE}, plot the density of values (i.e., the number in each bin divided by the total number of cells with non-\code{NA} values).}

\item{...}{Arguments to pass to \code{\link[graphics:barplot]{graphics::barplot()}}.}
}
\value{
A named list of \code{data.frame}s (invisibly), one per layer plotted, and creates a graph.
}
\description{
This function creates a histogram of values in \code{GRaster}. The function is modeled after \code{\link[graphics:hist]{graphics::hist()}}, but actually uses \code{\link[graphics:barplot]{graphics::barplot()}}.
}
\examples{
if (grassStarted()) {

# Example data
madElev <- fastData("madElev") # elevation raster
madLANDSAT <- fastData("madLANDSAT") # multi-layer raster
madRivers <- fastData("madRivers") # lines vector

# Convert SpatRaster to GRaster and SpatVector to GVector
elev <- fast(madElev)
rivers <- fast(madRivers)
landsat <- fast(madLANDSAT)

# Plot:
plot(elev)
plot(rivers, add = TRUE)

# Histograms:
hist(elev)
hist(landsat)

# Plot surface reflectance in RGB:
plotRGB(landsat, 3, 2, 1) # "natural" color
plotRGB(landsat, 4, 1, 2, stretch = "lin") # emphasize near-infrared (vegetation)

# Make composite map from RGB layers and plot in grayscale:
comp <- compositeRGB(r = landsat[[3]], g = landsat[[2]], b = landsat[[1]])
grays <- paste0("gray", 0:100)
plot(comp, col = grays)

}
}
