% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{predict.fast_logistic_regression}
\alias{predict.fast_logistic_regression}
\title{FastLR Wrapper Predictions}
\usage{
\method{predict}{fast_logistic_regression}(object, newdata, type = "response", ...)
}
\arguments{
\item{object}{The object built using the \code{fast_logistic_regression} or \code{fast_logistic_regression_stepwise} wrapper functions}

\item{newdata}{A matrix of observations where you wish to predict the binary response.}

\item{type}{The type of prediction required. The default is \code{"response"} which is on the response scale (i.e. probability estimates) and the alternative is \code{"link"} which is the linear scale (i.e. log-odds).}

\item{...}{Further arguments passed to or from other methods}
}
\value{
A numeric vector of length \code{nrow(newdata)} of estimates of P(Y = 1) for each unit in \code{newdata}.
}
\description{
Predicts returning p-hats
}
\examples{
library(MASS); data(Pima.te)
flr = fast_logistic_regression(
  Xmm = model.matrix(~ . - type, Pima.te), 
  ybin = as.numeric(Pima.te$type == "Yes")
)
phat = predict(flr, model.matrix(~ . - type, Pima.te))
}
