% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_idd_periods.R
\name{get_idd_periods}
\alias{get_idd_periods}
\title{Period for Inevitable Disclosure Doctrine (IDD)}
\usage{
get_idd_periods(min_date, max_date)
}
\arguments{
\item{min_date}{First date of sample period}

\item{max_date}{Last date of sample period}
}
\value{
tibble with four columns: state, period_type, start_date, end_date
}
\description{
Periods defined by precedent-setting legal cases adopting or rejecting the
Inevitable Disclosure Doctrine (IDD) by state.
}
\details{
Three kinds of period by state:
\itemize{
\item Pre-adoption
\item Post-adoption
\item Post-rejection
}
}
\examples{
idd_periods <- get_idd_periods(min_date = "1994-01-01",
                               max_date = "2010-12-31")
idd_periods
}
