% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_driver_telemetry.R
\name{get_driver_telemetry}
\alias{get_driver_telemetry}
\title{Load Telemetry Data for a Driver}
\usage{
get_driver_telemetry(
  season = get_current_season(),
  round = 1,
  session = "R",
  driver,
  laps = "fastest",
  log_level = "WARNING",
  fastest_only = lifecycle::deprecated(),
  race = lifecycle::deprecated()
)
}
\arguments{
\item{season}{number from 2018 to current season (defaults to current season).}

\item{round}{number from 1 to 23 (depending on season selected). Also accepts race name.}

\item{session}{the code for the session to load Options are \code{'FP1'}, \code{'FP2'}, \code{'FP3'},
\code{'Q'}, \code{'S'}, \code{'SS'}, \code{'SQ'}, and \code{'R'}. Default is \code{'R'}, which refers to Race.}

\item{driver}{three letter driver code (see \code{load_drivers()} for a list)}

\item{laps}{which lap's telemetry to return. One of an integer lap number (<= total laps in the race), \code{fastest},
or \code{all}. Note that integer lap choice requires \code{fastf1} version 3.0 or greater.}

\item{log_level}{Detail of logging from fastf1 to be displayed. Choice of:
\code{'DEBUG'}, \code{'INFO'}, \code{'WARNING'}, \code{'ERROR'} and \code{'CRITICAL'}. See \href{https://docs.fastf1.dev/fastf1.html#configure-logging-verbosity}{fastf1 documentation}.}

\item{fastest_only}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{fastest_only} is no longer supported, indicated preferred
laps in \code{laps}.}

\item{race}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{race} is no longer supported, use \code{round}.}
}
\value{
A tibble with telemetry data for selected driver/session.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{get_driver_telemetry()} was renamed to \code{load_driver_telemetry()} to create a more
consistent API.
}
\keyword{internal}
