% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation_diagnostics.R
\name{aggregation_diagnostics}
\alias{aggregation_diagnostics}
\title{Compute multiple aggregation diagnostics for a set of variables}
\usage{
aggregation_diagnostics(data, group_var, variables)
}
\arguments{
\item{data}{A data frame containing event report level data.}

\item{group_var}{A character string naming the column that uniquely identifies events (e.g., "event_id").}

\item{variables}{A character vector of column names to include in the diagnostics.}
}
\value{
A tibble with one row per variable and columns:
\describe{
  \item{variable}{The name of each variable.}
  \item{dscore}{Mean divergence score.}
  \item{dscore_normalized}{Normalized divergence score.}
  \item{mean_sd}{Mean within-event standard deviation (numeric variables only).}
  \item{mean_range}{Mean within-event range (numeric variables only).}
  \item{share_disagreement}{Share of events with any disagreement.}
  \item{modal_confidence}{Average modal confidence per variable.}
}

#' @importFrom dplyr full_join
}
\description{
This convenience function runs all six diagnostic functions in the package,
mean divergence, normalized divergence, mean standard deviation, mean range,
share of events with disagreement, and modal confidence, and returns a combined
tibble with one row per variable.
}
\details{
The function handles mixed-type input: each diagnostic is only run on the subset
of variables for which it is valid. Variables that do not apply to a particular
diagnostic will have `NA` in that column.
}
\examples{
small_maverick_event_report \%>\%
  aggregation_diagnostics(
    group_var = "event_id",
    variables = c("city", "deaths_best", "actor1")
   )

}
