#' A Subset of the MAVERICK Event Report Dataset
#'
#' This dataset contains 100 event reports from the MAVERICK event report dataset,
#' arranged by `event_id`. It is used for examples and vignettes in the `eventreport` package.
#'
#' @format A subset of the MAVERICK data frame with 100 rows and 10 columns:
#' \describe{
#' \item{id}{A unique event report identifier.}
#' \item{event_id}{A unique event identifier assigned by the coders. Needed to aggregate event reports into events.}
#' \item{country}{A character class variable that contains the name of the country in which the event took place.}
#' \item{date_start}{A character class variable that contains the earliest possible event date expressed in YYYY-MM-DD format.}
#' \item{city}{A character class variable that contains the name of the city or village in which the event took place.}
#' \item{location}{A character class variable that contains a text description of the most precise event location described in the report.}
#' \item{actor1}{A character class variable that contains the name of the actor involved in the event.}
#' \item{deaths_best}{An integer class variable that records the best estimated number of deaths.}
#' \item{injuries_best}{An integer class variable that records the best estimated number of injured people.}
#' \item{source}{A character class variable that records the source.}
#'   ...
#' }
#' @source MAVERICK dataset
"small_maverick_event_report"
