\name{Approximate distance variance}
\alias{adcov}
\title{
Approximate distance variance
}

\description{
Approximate distance variance.
}

\usage{
adcov(x, y, bc = FALSE, K = 100)
}

\arguments{
\item{x}{
A numerical matrix.
}
\item{y}{
A numerical matrix.
}
\item{bc}{
If you want the bias-corrected distance correlation set this equal to TRUE.
}
\item{K}{
The number of projections to perform.
}
}

\details{
The approximate distance covariance of Huand and Huo (2022) is computed.
}

\value{
The approximate distance covariance.
}

\references{
Szekely G.J., Rizzo M.L. and Bakirov N.K.(2007). Measuring and Testing Independence
by Correlation of Distances. Annals of Statistics, 35(6):2769--2794.

Szekely G. J. and Rizzo M. L. (2023). The Energy of Data and Distance Correlation.
Chapman and Hall/CRC.

Huang C. and Huo X. (2022). A statistically and numerically efficient independence test based on random projections and distance covariance. Frontiers in Applied Mathematics and Statistics, 7: 779841.

Tsagris M. and Papadakis M. (2025). Fast and light-weight energy statistics using the R package Rfast.
https://arxiv.org/abs/2501.02849
}

\author{
Michail Tsagris and Manos Papadakis.

R implementation and documentation: Michail Tsagris <mtsagris@uoc.gr>.
}
%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{adcov}, \link{adcov.test}
}
}

\examples{
x <- as.matrix(iris[1:50, 1:4])
y <- as.matrix(iris[51:100, 1:4])
res <- dvar(x[, 1])
dcor(x, y)
}

