% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol_median.R
\name{vol.median}
\alias{vol.median}
\title{Median filter on a volume}
\usage{
vol.median(vol, alias = "", description = NULL)
}
\arguments{
\item{vol}{"volume" class object.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (vol$object.alias, "median")}.}
}
\value{
Returns a "volume" class object (see \link[espadon]{espadon.class}
for class definitions), with the same grid and modality
as \code{vol}, in which voxels are filtered by a 26-connectivity median filter.
}
\description{
The \code{vol.median} function applies a 26-connectivity median
filter on all the voxels of a "volume" class object.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 3
pat <- toy.load.patient (modality = c ("ct"), dxyz = rep (step, 3))
CT.median <- vol.median (pat$ct[[1]])

display.plane (CT.median, view.type = "sagi", view.coord = 61, 
               interpolate = FALSE)
}
