% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckd.R
\name{eGFR_child_SCr}
\alias{eGFR_child_SCr}
\alias{eGFR_child_SCr.data.frame}
\alias{eGFR_child_SCr.units}
\alias{eGFR_child_SCr.numeric}
\title{eGFR Pediatric SCr and Height}
\usage{
eGFR_child_SCr(...)

\method{eGFR_child_SCr}{data.frame}(.data, SCr, height, ...)

\method{eGFR_child_SCr}{units}(SCr, height, ...)

\method{eGFR_child_SCr}{numeric}(SCr, height, ...)
}
\arguments{
\item{...}{Further optional arguments}

\item{.data}{(data.frame) A data.frame, optional}

\item{SCr}{Serum creatinine
column name, or vector of units or numeric if \code{.data} is not provided}

\item{height}{Height of patient
column name, or vector of units or numeric if \code{.data} is not provided}
}
\value{
Estimated GFR
of the same type provided (numeric or units)
}
\description{
Using KDIGO 2012 Clinical Practice Guideline for
the Evaluation and Management of Chronic Kidney Disease
Volume 3 | Issue 1 | January 2013
}
\details{
See \url{https://kdigo.org/guidelines/ckd-evaluation-and-management/} for more details
}
\examples{
eGFR_child_SCr(eGFR_pt_data,
  SCr = "SCr_", height = "height_"
)

eGFR_pt_data \%>\%
  dplyr::mutate(eGFR = eGFR_child_SCr(
    SCr = SCr_, height = height_,
  ))
}
