% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_fun.R
\name{fmt_ci}
\alias{fmt_ci}
\alias{fmt_pci}
\alias{fmt_pci_df}
\alias{fmt_ci_df}
\title{Helper to format confidence interval for text}
\usage{
fmt_ci(
  e = numeric(),
  l = numeric(),
  u = numeric(),
  digits = 2,
  percent = TRUE,
  separator = "-"
)

fmt_pci(
  e = numeric(),
  l = numeric(),
  u = numeric(),
  digits = 2,
  percent = TRUE,
  separator = "-"
)

fmt_pci_df(
  x,
  e = 3,
  l = e + 1,
  u = e + 2,
  digits = 2,
  percent = TRUE,
  separator = "-"
)

fmt_ci_df(
  x,
  e = 3,
  l = e + 1,
  u = e + 2,
  digits = 2,
  percent = TRUE,
  separator = "-"
)
}
\arguments{
\item{e}{the column of the estimate (defaults to the third column). Otherwise, a number}

\item{l}{the column of the lower bound (defaults to the fourth column). Otherwise, a number}

\item{u}{the column of the upper bound (defaults to the fifth column), otherwise, a number}

\item{digits}{the number of digits to show}

\item{percent}{if \code{TRUE} (default), converts the number to percent, otherwise
it's treated as a raw value}

\item{separator}{what to separate lower and upper confidence intervals with,
default is "-"}

\item{x}{a data frame}
}
\value{
a text string in the format of "e\\% (CI l--u)"
}
\description{
This function is mainly used for placing in the text fields of Rmarkdown
reports.
}
\examples{

cfr <- data.frame(x = 1, y = 2, est = 0.5, lower = 0.25, upper = 0.75)
fmt_pci_df(cfr)

# If the data starts at a different column, specify a different number
fmt_pci_df(cfr[-1], 2, d = 1)

# It's also possible to provide numbers directly and remove the percent sign.
fmt_ci(pi, pi - runif(1), pi + runif(1), percent = FALSE)
}
