% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_max.R
\name{lambda_max}
\alias{lambda_max}
\title{Lambda Max}
\usage{
lambda_max(y, x, standardize = TRUE, alpha = 0, lmin_factor = 1e-04,
  ...)
}
\arguments{
\item{y}{the response vector}

\item{x}{the predictor matrix}

\item{standardize}{logicial, should the x matrix be standardized?}

\item{alpha}{the glmnet alpha value}

\item{lmin_factor}{the smallest lambda value is defined as \code{lmin_factor
* max(lambda)} where \code{max(lambda)} is determined by this function.}

\item{...}{other args}
}
\description{
Determine the lambda_max value that would be generated from a call to
\code{\link[glmnet]{glmnet}} without making that call.
}
\examples{

data(tbi)
Xmat <- model.matrix( ~ . - injury1 - injury2 - injury3 - 1, data = tbi)
Yvec <- matrix(tbi$injury1, ncol = 1)

alphas <- seq(0, 1, length = 20)
lambda_max(Yvec, Xmat, alpha = alphas)

# Look at different options for standardizing the inputs.

dat <-
  expand.grid(standardize = c(TRUE, FALSE),
              alpha = alphas)

lmax <-
  Map(lambda_max,
      standardize = dat$standardize,
      alpha = dat$alpha,
      MoreArgs = list(y = Yvec, x = Xmat))


gmax <-
  Map(glmnet::glmnet,
      standardize = dat$standardize,
      alpha = dat$alpha,
      MoreArgs = list(y = Yvec, x = Xmat))

dat$gmax <- sapply(gmax, function(f) f$lambda[1])
dat$lmax <- unlist(lmax)

par(mfrow = c(1, 2))

with(subset(dat, standardize == TRUE),
     {
       plot(log10(gmax), log10(lmax))
       abline(0, 1)
       title(main = "standardize == TRUE")
     })

with(subset(dat, standardize == FALSE),
     {
       plot(log10(gmax), log10(lmax))
       abline(0, 1)
       title(main = "standardize == FALSE")
     })

}
