% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_validation.R
\name{model_validation}
\alias{model_validation}
\title{Model validation options}
\usage{
model_validation(formula, data, family = binomial(link = "logit"),
                 weights = NULL, cv = FALSE, partition_index = NULL,
                 k = NULL, dependent = NULL, n_threshold = 100,
                 keep_coefficients = FALSE, seed = 1)
}
\arguments{
\item{formula}{(character) \code{expression} to be used as a glm \code{formula}.}

\item{data}{data.frame with dependent and independent variables.}

\item{family}{a \code{family} object for models used by functions such as \code{glm}.
Default = binomial(link = "logit").}

\item{weights}{(numeric) vector with weights for observations. Default = NULL.}

\item{cv}{(logical) whether to use a k-fold cross validation for evaluation.
Default = FALSE.}

\item{partition_index}{list of indices for cross validation in k-fold.
Obtained with the function \code{\link{kfold_partition}}. Default = NULL.}

\item{k}{(numeric) number of folds for a new k-fold index preparation.
Ignored if \code{partition_index} is defined or if \code{cv} = FALSE. Default = NULL.}

\item{dependent}{(character) name of dependent variable. Ignore if
\code{cv} = FALSE. Default = NULL.}

\item{n_threshold}{(numeric) number of threshold values to be used for ROC.
Default = 100.}

\item{keep_coefficients}{(logical) whether to keep model coefficients.
Default = FALSE.}

\item{seed}{(numeric) a seed number. Default = 1.}
}
\value{
A data.frame with results from evaluation.
}
\description{
Model evaluation using entire set of data and a k-fold cross validation
approach. Models are assessed based on discrimination power (ROC-AUC),
classification ability (accuracy, sensitivity, specificity, TSS, etc.),
and the balance between fitting and complexity (AIC).
}
\examples{
# Load species occurrences and environmental data.
data("enm_data", package = "enmpa")
head(enm_data)

# Custom formula
form <- c("Sp ~ bio_1 + I(bio_1^2) + I(bio_12^2)")

# Model evaluation using the entire set of records
model_validation(form, data = enm_data)

# Model evaluation using a k-fold cross-validation (k = 3)
model_validation(form, data = enm_data, cv = TRUE, k = 3, dependent = "Sp")
}
