% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_utils.R
\name{detect_database_corruption}
\alias{detect_database_corruption}
\title{Detect potentially corrupted database data}
\usage{
detect_database_corruption(
  data,
  dataset,
  vintage,
  states = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame to check}

\item{dataset}{Character, "ami" or "fpl"}

\item{vintage}{Character, "2018" or "2022"}

\item{states}{Character vector of expected states (NULL = all US states)}

\item{verbose}{Logical, print warnings}
}
\value{
List with: is_corrupted (logical), issues (character vector), recommendation (character)
}
\description{
Checks if loaded data appears corrupted (too small, missing states, missing columns).
\strong{Does NOT automatically delete} - only warns and provides recommendations.
}
\keyword{internal}
