% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_exposure.R
\name{std_exposure}
\alias{std_exposure}
\title{Simulate exposure data using default methods}
\usage{
std_exposure(n, central, sd = NULL, trend = "no trend",
  exposure_type = "binary", slope, amp, start.date = "2000-01-01", ...)
}
\arguments{
\item{n}{A non-negative integer specifying the number of days to simulate.}

\item{central}{A numeric value specifying the mean probability of exposure
(for binary data) or the mean exposure value (for continuous data).}

\item{sd}{A numeric value giving the standard deviation of the exposure
values from the exposure trend line.}

\item{trend}{A character string that specifies the desired trend function.
Options are:
\itemize{
  \item{"no trend": No trend, either seasonal or long-term (default).}
  \item{"cos1": A seasonal trend only.}
  \item{"cos2": A seasonal trend with variable amplitude across years.}
  \item{"cos3": A seasonal trend with steadily decreasing amplitude over time.}
  \item{"linear": A linear long-term trend with no seasonal trend.}
  \item{"curvilinear": A curved long-term trend with no seasonal trend.}
  \item{"cos1linear": A seasonal trend plus a linear long-term trend.}
  }
See the package vignette for examples of the shapes of these trends.}

\item{exposure_type}{A character string specifying the type of exposure.
Choices are "binary" or "continuous".}

\item{slope}{A numeric value specifying the slope of the trend, to be used
with \code{trend = "linear"} or \code{trend = "cos1linear"}.}

\item{amp}{A numeric value specifying the amplitude of the seasonal trend.
Must be between -1 and 1.}

\item{start.date}{A date of the format "yyyy-mm-dd" from which to begin
simulating daily exposures}

\item{...}{Optional arguments to a custom trend function}
}
\value{
A data frame with two columns: date (\code{date}) and simulated
   exposure values (\code{x}).
}
\description{
Simulates binary or continuous exposure data with or without seasonal trends
using default functions.
}
\examples{
std_exposure(n = 5, central = .1, trend = "cos1", amp = .02)
std_exposure(n = 5, central = 50, sd = 5, trend = "cos3", amp = .6,
             exposure_type = "continuous", start.date = "2001-04-01")
std_exposure(n=50, central=.1, amp=.05,cust_expdraw=rnbinom,
             cust_expdraw_args=list(size=10))

}
