% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.upd}
\alias{ec.upd}
\title{Update option lists}
\usage{
ec.upd(wt, ...)
}
\arguments{
\item{wt}{An echarty widget}

\item{...}{R commands to add/update chart option lists}
}
\description{
Chain commands after ec.init to add or update chart items
}
\details{
\emph{ec.upd} makes changes to a chart already set by \link{ec.init}.\cr
It should be always piped(chained) after \link{ec.init}.\cr
All numerical indexes for series,visualMap,etc. are JS-counted starting at 0.\cr
}
\examples{
library(dplyr)
df <- data.frame(x= 1:30, y= runif(30, 5, 10), cat= sample(LETTERS[1:3],size=30,replace=TRUE)) |>
      mutate(lwr= y-runif(30, 1, 3), upr= y+runif(30, 2, 4))
band.df <- df  |> group_by(cat) |> group_split()
sband <- list()
for(ii in seq_along(band.df))   # build all bands
  sband <- append(sband,
    ecr.band(band.df[[ii]], 'lwr', 'upr', type='stack', smooth=FALSE,
       name= unique(band.df[[ii]]$cat), areaStyle= list(color=c('blue','green','yellow')[ii]))
  )

df |> group_by(cat) |> 
ec.init(load='custom', series.param= list(type='line'), 
        xAxis=list(data=c(0,unique(df$x)), boundaryGap=FALSE) ) |> 
ec.upd({ series <- append(series, sband) })

}
