% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nesting.R
\name{e_insert_data}
\alias{e_insert_data}
\title{Insert binded data}
\usage{
e_insert_data(e, .serie, .data)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{.serie}{Serie's index to add the data.}

\item{.data}{Column names for the new data.}
}
\description{
Utility function to attach an existing column(s) from your data to an existing series
}
\details{
This inserts new data into a series's values which allows for use in mapping things like e_visual_map
or tooltip parameters. This function also works when using timelines.
}
\examples{
mtcars |>
 e_charts(mpg) |>
 e_scatter(wt, scale = e_scale) |>
 e_insert_data(.serie = 1, .data = "qsec") |>
 e_visual_map(qsec, scale = e_scale, dimension = 2) |>
 e_tooltip(trigger = "item",
           formatter = htmlwidgets::JS("function(params) {
                                       return 'mpg: ' + params.value[0] +
                                       '<br />wt: ' + params.value[1] +
                                       '<br />qsec: ' + params.value[2];
                                       }")
 )

}
