% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-theme.R
\name{theme_publication}
\alias{theme_publication}
\title{Custom ggplot2 Theme for Academic Publications}
\usage{
theme_publication(base_size = 12, base_family = "sans")
}
\arguments{
\item{base_size}{numeric, the base font size. Default is 12.}

\item{base_family}{character, the base font family. Default is "sans".}
}
\value{
A ggplot2 theme object that can be applied to ggplot2 plots.

ggplot2 theme.
}
\description{
\code{theme_publication} creates a custom ggplot2 theme designed for academic publications, ensuring clarity, readability, and a professional appearance.
It is based on \code{theme_classic()} and includes additional refinements to axis lines, text, and other plot elements to meet the standards of high-quality academic figures.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  theme_publication()
print(p)
}
