% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{epm_fetch}
\alias{epm_fetch}
\title{Fetch Raw Records from Pubmed.}
\usage{
epm_fetch(
  x,
  format = "xml",
  api_key = NULL,
  write_to_file = FALSE,
  outfile_path = NULL,
  outfile_prefix = NULL,
  store_contents = TRUE,
  encoding = "UTF-8",
  verbose = TRUE
)
}
\arguments{
\item{x}{An `easyPubMed` object.}

\item{format}{String, the desired format for the raw records. 
This argument must take one of the following
values: `c("uilist", "medline", "xml")` and defaults to `"xml"`.}

\item{api_key}{String, corresponding to the NCBI API token (if available). 
NCBI token strings can be requested from NCBI. Record download will be 
faster if a valid NCBI token is used. This argument can be `NULL`.}

\item{write_to_file}{Logical of length 1. Shall raw records be written to 
a file on the local machine. It defaults to `FALSE`.}

\item{outfile_path}{Path to the folder on the local machine where files 
will be saved (if `write_to_file` is `TRUE`). It must point to an
already existing directory. If `NULL`, the working directory will be used.}

\item{outfile_prefix}{String, prefix that will be added to the name
of each file written to the local machine. This argument is parsed only 
when `write_to_file` is `TRUE`. If `NULL`, an arbitrary prefix will be added 
(easypubmed_job_YYYYMMDDHHMM).}

\item{store_contents}{Logical of length 1. Shall raw records be stored
in the `easyPubMed` object. It defaults to `TRUE`. It may convenient to 
switch this to `FALSE` when downloading large number of records. 
If `store_contents` is `FALSE`, `write_to_file` must be `TRUE`.}

\item{encoding}{String, the encoding of the records retrieved from PubMed. 
Typically, this is 'UTF-8'.}

\item{verbose}{Logical, shall details about the 
progress of the operation be printed to console.}
}
\value{
an easyPubMed object.
}
\description{
Fetch raw PubMed records from PubMed. Records can be downloaded 
in text or xml format and stored into a local object or written to 
local files.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  x <- epm_query(query_string = 'Damiano Fantini[AU] AND "2018"[PDAT]')
  x <- epm_fetch(x = x, format = 'uilist')
  x
}, silent = TRUE)
setTimeLimit(elapsed = Inf)


}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
