% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_submit_q}
\alias{EPM_submit_q}
\title{Submit a Query and Read the Response from the Server.}
\usage{
EPM_submit_q(qurl)
}
\arguments{
\item{qurl}{String (character vector of length 1), corresponding to the 
query URL to the remote server.}
}
\value{
Character vector including the response from the server.
}
\description{
Submit a request to a server (typically, the Entrez Eutils server) and 
capture the response.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  qry <- paste0("https://eutils.ncbi.nlm.nih.gov/entrez/eutils/", 
                "esearch.fcgi?db=pubmed&term=easyPubMed")
  easyPubMed:::EPM_submit_q(qry)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
