% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edl_netrc.R
\name{edl_unset_netrc}
\alias{edl_unset_netrc}
\title{edl_unset_netrc}
\usage{
edl_unset_netrc(
  netrc_path = edl_netrc_path(),
  cookie_path = edl_cookie_path(),
  cloud_config = TRUE
)
}
\arguments{
\item{netrc_path}{Path to the .netrc file to be created. Defaults to the
appropriate R package configuration location given by \code{\link[tools:userdir]{tools::R_user_dir()}}.}

\item{cookie_path}{Path to the file where cookies will be stored.  Defaults
to the appropriate R package configuration location given by
\code{\link[tools:userdir]{tools::R_user_dir()}}.}

\item{cloud_config}{set \code{\link[=gdal_cloud_config]{gdal_cloud_config()}} env vars as well? logical,
default \code{TRUE}.}
}
\value{
invisible TRUE, if successful (even if no env is set.)
}
\description{
Unsets environmental variables set by edl_netrc() and removes
configuration files set by \code{\link[=edl_netrc]{edl_netrc()}}.
}
\details{
Note that this function should rarely be necessary, as unlike bearer
token-based auth, netrc is mapped by domain name and will not interfere
with access to non-earthdata-based URLs.  It may still be necessary
to deactivate in order to use one of the other earthdatalogin authentication
methods.

To unset environmental variables without removing files, set that file
path argument to \code{""} (see examples)

Note that GDAL_HTTP_NETRC defaults to YES.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

 edl_unset_netrc()

 # unset environmental variables only
 edl_unset_netrc("", "")
\dontshow{\}) # examplesIf}
}
