% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_integer.R
\name{integer_parameter}
\alias{integer_parameter}
\title{Define a integer parameter}
\usage{
integer_parameter(
  id,
  default,
  distribution,
  description = NULL,
  tuneable = TRUE
)
}
\arguments{
\item{id}{The name of the parameter.}

\item{default}{The default value of the parameter.}

\item{distribution}{A distribution from which the parameter can be sampled.}

\item{description}{An optional (but recommended) description of the parameter.}

\item{tuneable}{Whether or not a parameter is tuneable.}
}
\description{
Define a integer parameter
}
\examples{
integer_parameter(
  id = "k",
  default = 5,
  distribution = uniform_distribution(3, 10),
  description = "The number of clusters."
)

integer_parameter(
  id = "num_iter",
  default = 100,
  distribution = expuniform_distribution(10, 10000),
  description = "The number of iterations."
)
}
\seealso{
\link{dynparam} for an overview of all dynparam functionality.
}
