% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imsM-data.R
\docType{data}
\name{imsM}
\alias{imsM}
\title{Ratings on the full Investment Model Scale (IMS) from 282 (M)ixed-sex couples}
\format{
A data frame with 282 rows and 40 variables:
\describe{
\item{sat.g1_f}{Satisfaction item 1 for female partner}
\item{sat.g2_f}{Satisfaction item 2 for female partner}
\item{sat.g3_f}{Satisfaction item 3 for female partner}
\item{sat.g4_f}{Satisfaction item 4 for female partner}
\item{sat.g5_f}{Satisfaction item 5 for female partner}
\item{qalt.g1_f}{Quality of alternatives item 1 for female partner}
\item{qalt.g2_f}{Quality of alternatives item 2 for female partner}
\item{qalt.g3_f}{Quality of alternatives item 3 for female partner}
\item{qalt.g4_f}{Quality of alternatives item 4 for female partner}
\item{qalt.g5_f}{Quality of alternatives item 5 for female partner}
\item{invest.g1_f}{Investment item 1 for female partner}
\item{invest.g2_f}{Investment item 2 for female partner}
\item{invest.g3_f}{Investment item 3 for female partner}
\item{invest.g4_f}{Investment item 4 for female partner}
\item{invest.g5_f}{Investment item 5 for female partner}
\item{com1_f}{Commitment items item 1 for female partner}
\item{com2_f}{Commitment items item 2 for female partner}
\item{com3_f}{Commitment items item 3 for female partner}
\item{com4_f}{Commitment items item 4 for female partner}
\item{com5_f}{Commitment items item 5 for female partner}
\item{sat.g1_m}{Satisfaction item 1 for male partner}
\item{sat.g2_m}{Satisfaction item 2 for male partner}
\item{sat.g3_m}{Satisfaction item 3 for male partner}
\item{sat.g4_m}{Satisfaction item 4 for male partner}
\item{sat.g5_m}{Satisfaction item 5 for male partner}
\item{qalt.g1_m}{Quality of alternatives item 1 for male partner}
\item{qalt.g2_m}{Quality of alternatives item 2 for male partner}
\item{qalt.g3_m}{Quality of alternatives item 3 for male partner}
\item{qalt.g4_m}{Quality of alternatives item 4 for male partner}
\item{qalt.g5_m}{Quality of alternatives item 5 for male partner}
\item{invest.g1_m}{Investment item 1 for male partner}
\item{invest.g2_m}{Investment item 2 for male partner}
\item{invest.g3_m}{Investment item 3 for male partner}
\item{invest.g4_m}{Investment item 4 for male partner}
\item{invest.g5_m}{Investment item 5 for male partner}
\item{com1_m}{Commitment items item 1 for male partner}
\item{com2_m}{Commitment items item 2 for male partner}
\item{com3_m}{Commitment items item 3 for male partner}
\item{com4_m}{Commitment items item 4 for male partner}
\item{com5_m}{Commitment items item 5 for male partner}
}
}
\usage{
data(imsM)
}
\description{
A data set containing 5 ratings for each of (1) satisfaction, (2) quality of alternatives,
(3) investment, and 4 (commitment) for each member of a mixed-sex romantic dyad.
Measured using the Investment Model Scale subscales
(Rusbult, Martz, & Agnew, 1998). Data are from Sakaluk, Fisher, and Kilshaw's (2021) study
of dyadic invariance. Variable names have been re-coded to follow a stem-item-partner ("sip")
order, with a delimiter ("_") between the item number and partner distinguishing character.
}
\references{
Sakaluk, J. K., Fisher, A. N., & Kilshaw, R. E.(2021). Dyadic measurement invariance and its importance for replicability in romantic relationship research. \emph{Personal Relationships}, \emph{28}(1), 190-226.  .
}
\keyword{datasets}
