% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{ddFit}
\alias{ddFit}
\alias{ddFit.data.frame}
\alias{ddFit.rings}
\alias{ddFit.list}
\alias{ddFit.xyLayout}
\alias{ddFit.ringscc}
\title{Fit Distance Distribution Model(s)}
\usage{
ddFit(x, ...)

\method{ddFit}{data.frame}(
  x,
  distr = "standard",
  scVar = NULL,
  rCol = "r",
  expoCol = "exposure",
  ncarcCol = "ncarc",
  silent = FALSE,
  ...
)

\method{ddFit}{rings}(
  x,
  distr = "standard",
  scVar = NULL,
  rCol = "r",
  expoCol = "exposure",
  ncarcCol = "ncarc",
  silent = FALSE,
  ...
)

\method{ddFit}{list}(
  x,
  distr = "standard",
  scVar = NULL,
  rCol = "r",
  expoCol = "exposure",
  ncarcCol = "ncarc",
  silent = FALSE,
  ...
)

\method{ddFit}{xyLayout}(
  x,
  distr = "standard",
  scVar = NULL,
  notSearched = NULL,
  rCol = "r",
  ncarcCol = "ncarc",
  unitCol = "turbine",
  silent = FALSE,
  ...
)

\method{ddFit}{ringscc}(
  x,
  distr = "standard",
  scVar = NULL,
  rCol = "r",
  expoCol = "exposure",
  ncarcCol = "ncarc",
  silent = FALSE,
  ...
)
}
\arguments{
\item{x}{a search plot layout object to fit carcass distribution models to. The
layout may be a data frame with columns for ring radii, exposure (or searched
area in each ring), search class variable (optional), and number of carcasses
in each ring;}

\item{...}{ignored}

\item{distr}{names (vector of character strings) of glm distribution templates
to fit. Default is \code{distr = "standard"} to fit the standard models listed in the
description above. Setting \code{distr = "all"} will fit both the standard
models and the supplementary models. Also, any subset of the models may be fit
by using, for example, \code{distr = c("xep01", "lognormal")} to fit only
the \code{"xep01"} and \code{"lognormal"} models, or
\code{distr = exclude(c("xep123", "constant"))} to fit all standard models except
\code{"xep123"} and \code{"constant"}, or \code{distr = exclude("lognormal", 
mod_all)} to fit all the models except the lognormal.}

\item{scVar}{Search class variable to include in the model (optional). \code{scVar}
is ignored if \code{x} is not a \code{shapeLayout} or \code{xyLayout} object.
If \code{x} is a \code{shapeLayout} object, \code{scVar} may be either \code{NULL}
or the name of a single column with search class data. If \code{x} is an \code{xyLayout}
object, \code{scVar} may be either NULL or a vector of names of search class
variables to include in the models. If \code{x} is a data frame for a site 
"simple" layout turbines with varying detection probabilities among turbines,
\code{x} must have a column named "type" to indicate a search plot type. The
"type" for each turbine is a character string to differentiate turbine types
that may have different detection probababilities (e.g., turbines 1 and 2
might be cleared plots with a relatively low carcass detection probability, while
turbines 3 and 4 are searched on only the roads and pads with a relatively high
carcass detection probability.}

\item{rCol}{name of the distance column (which gives the outer radii of the rings).
 This will be correct by default for objects coming from \code{\link{prepRing}} 
and will rarely need to be explicitly specified.}

\item{expoCol}{name of the column with the exposure, which is the area in the ring
with outer radius \code{rCol}. This will be correct by default for objects
coming from \code{\link{prepRing}} and will rarely need to be 
explicitly specified.}

\item{ncarcCol}{name of the column with tallies of carcasses by ring. This
will be correct by default for objects coming from \code{\link{prepRing}} 
and will rarely need to be explicitly specified.}

\item{silent}{set \code{silent = TRUE} to suppress information printed to the
console as the calculations proceed, which may be useful when running 
simulations.}

\item{notSearched}{the name of the level (if any) in \code{scVar} that
indicates an unsearched area}

\item{unitCol}{name of the column with turbine IDs}
}
\value{
A list of fitted glm models as \code{\link[=ddFit]{dd}} objects in a 
 \code{\link[=ddFit]{ddArray}}
 object if a vector of distributions is fit, or a single \code{\link[=ddFit]{dd}} 
 object if a single model is fit. The \code{\link[=ddFit]{dd}} objects are 
 lists that include the following elements:
 \describe{
   \item{\code{\link[stats]{glm}}}{the fitted model}
   \item{\code{$distr}}{name of the distribution (\code{"xep01"}, etc.)}
   \item{\code{$parms}}{vector of distribution parameter estimates (or \code{NA}
     if the model based on the MLE is not extensible)}
   \item{\code{$varbeta}}{the variance-covariance matrix of the glm parameter
     estimates. NOTE: This is identical to the covariance matrix from the glm,
     which can be extracted via \code{summary(x)$cov.unscaled}}
   \item{\code{$scVar}}{name of the (optional) search class variable (or \code{NULL})}
   \item{\code{$ncarc}}{number of carcasses}
   \item{\code{$aicc}}{the AICc value of the fit}
   \item{\code{$n}}{number of rings}
   \item{\code{$k}}{number of parameters}
   \item{\code{$srad}}{search radius}
 }
 When a \code{dd} object is printed, only a small subset of the elements are
 shown. To see a full list of the objects, use \code{names(x)}. The elements
 can be extracted in the usual R way via \code{$} or \code{[[x]]}.
}
\description{
Fit generalized linear models (glm) for distance distribution 
 models corresponding to standard forms [xep1, xep01 (gamma), xep2 (Rayleigh), 
 xep02, xep12, xep012, xep123, xep0123 (normal-gamma with x = tau), lognormal,  
 truncated normal, Maxwell Boltzmann, and constant] and supplentary forms 
 [exponential, chi-squared, inverse gamma, and inverse Gaussian].

 The glm is converted to a probability distribution by dividing by a
 normalizing constant, namely the integral of the glm evaluated from 0 to
 infinity. In some cases (most notably when the leading coefficient of the
 glm is positive so the fitted curve does not converge to zero as x increases),
 converted to a probability distribution. In these cases, the distribution
 parameters are given as \code{NA}, but the fitted model itself is saved.
}
\examples{
 data(layout_simple) 
 data(carcass_simple)
 sitedata <- initLayout(layout_simple) # initialize
 ringdata <- prepRing(sitedata) # format site layout data for modeling
 ringsWithCarcasses <- addCarcass(carcass_simple, data_ring = ringdata) # add carcasses to site
 distanceModels <- ddFit(ringsWithCarcasses) # fit distance models
}
