% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tern.R
\name{tern_AET01_table}
\alias{tern_AET01_table}
\title{Generate Core Safety Tables (CSR Section 14.3.1) using \code{tern}/\code{rtables}}
\usage{
tern_AET01_table(
  adsl,
  adae,
  patient_var,
  treat_var,
  aesi_vars,
  aesi_heading = "Total number of patients with at least one",
  indent = "  "
)
}
\arguments{
\item{adsl}{A subject-level dataset (typically ADaM ADSL).}

\item{adae}{A dataset of adverse events, preprocessed with AESI flags.}

\item{patient_var}{A string indicating the subject identifier variable (e.g.,
\code{"USUBJID"}).}

\item{treat_var}{A string indicating the treatment arm variable (e.g., \code{"ARM"}).}

\item{aesi_vars}{A character vector of binary AESI flags in \code{adae}.}

\item{aesi_heading}{Ignored (included for interface compatibility).}

\item{indent}{Ignored (included for interface compatibility).}
}
\value{
A \code{TableTree} object from the \code{rtables} package.
}
\description{
\code{\link[=tern_AET01_table]{tern_AET01_table()}} produces a consolidated safety summary table using
\code{rtables} and \code{tern}. It mirrors the output and interface of
\code{\link[=AET01_table]{AET01_table()}}, generating standard adverse event summaries (e.g. death,
withdrawal, AESIs) for Clinical Study Reports (CSR) Section 14.3.1.
}
\details{
The function returns a single formatted \code{rtables} table summarising core
safety endpoints by treatment arm.
}
\examples{
tern_AET01_table(
  adsl = adsl,
  adae = aesi,
  patient_var = "USUBJID",
  treat_var = "ARM",
  aesi_vars = c("FATAL", "SER", "SERWD", "SERDSM", "RELSER",
                "WD", "DSM", "REL", "RELWD", "RELDSM", "SEV")
)

}
