% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleFastGaussian}
\alias{sampleFastGaussian}
\title{Sample a Gaussian vector using the fast sampler of BHATTACHARYA et al.}
\usage{
sampleFastGaussian(Phi, Ddiag, alpha)
}
\arguments{
\item{Phi}{\code{n x p} matrix (of predictors)}

\item{Ddiag}{\code{p x 1} vector of diagonal components (of prior variance)}

\item{alpha}{\code{n x 1} vector (of data, scaled by variance)}
}
\value{
Draw from N(mu, Sigma), which is \code{p x 1}, and is computed in \code{O(n^2*p)}
}
\description{
Sample from N(mu, Sigma) where Sigma = solve(crossprod(Phi) + solve(D))
and mu = Sigma*crossprod(Phi, alpha):
}
\note{
Assumes D is diagonal, but extensions are available
}
