% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmethods.R
\name{plot.dsp}
\alias{plot.dsp}
\title{Plot the Bayesian trend filtering fitted values}
\usage{
\method{plot}{dsp}(x, type, true_values = NULL, t01 = NULL, include_joint_bands = FALSE, ...)
}
\arguments{
\item{x}{an object of class 'dsp' from \code{\link[=dsp_fit]{dsp_fit()}}}

\item{type}{parameter name; must be included in x$mcmc_output}

\item{true_values}{(defaults to NULL) the \code{T x 1} vector of the true parameter}

\item{t01}{the observation points; if NULL, assume \code{T} equally spaced points from 0 to 1}

\item{include_joint_bands}{logical; if TRUE, compute simultaneous credible bands (only for \code{zeta},\code{omega},\code{yhat},\code{mu})}

\item{...}{currently not being used}
}
\value{
No return value, called for side effects
}
\description{
Plot the BTF posterior mean of the conditional expectation with posterior credible intervals (pointwise and joint),
the observed data, and true curves (if known)
}
\details{
The plotting behavior depends on the dimension of the posterior samples stored in \code{x$mcmc_output[[type]]}:
\itemize{
\item \strong{1D (scalar parameter):} A density plot is generated using a histogram with overlaid kernel density estimate. The posterior mean and 95\% credible interval are annotated, along with the true value if provided.
\item \strong{2D (vector-valued parameter over time):} A time-series plot is created, showing the posterior mean and 95\% pointwise credible intervals. If \code{include_joint_bands = TRUE} and the parameter is among \code{"omega"}, \code{"mu"}, \code{"yhat"}, or \code{"zeta"}, simultaneous credible bands are also drawn. Optionally, ground truth values (if supplied via \code{true_values}) are overlaid as orange dots.
\item \strong{3D (parameter array):} A sequence of time-series plots is drawn, one for each slice of the third dimension (e.g., different components of a multivariate function). Posterior mean, pointwise intervals, joint bands (when applicable), and ground truth are visualized in the same style as the 2D case. The function pauses after each plot, allowing the user to interactively inspect each one.
The x-axis values are given by \code{t01}. If not provided, they default to evenly spaced points in \eqn{[0, 1]}. For parameters with temporal differencing (e.g., \code{"evol_sigma_t2"}), initial time points used for prior initialization are automatically excluded.
If the model includes change point detection (\code{model = "changepoint"}), and both \code{omega} and \code{r} are present in the MCMC output, vertical lines are drawn at the estimated change point locations for plots of \code{"mu"}, \code{"yhat"}, or \code{"omega"}.
}
}
\examples{
set.seed(200)
signal = c(rep(0, 50), rep(10, 50))
noise = rep(1, 100)
noise_var = rep(1, 100)
for (k in 2:100){
  noise_var[k] = exp(0.9*log(noise_var[k-1]) + rnorm(1, 0, 0.5))
  noise[k] = rnorm(1, 0, sqrt(noise_var[k])) }

y = signal + noise
model_spec = dsp_spec(family = "gaussian", model = "changepoint",
                      D = 1, useAnom = TRUE, obsSV = "SV")
mcmc_output = dsp_fit(y, model_spec = model_spec, nsave = 500, nburn = 500)
# Estimated posterior mean vs ground truth
plot(mcmc_output, type = "mu", true_values = signal)
# Estimated innovation variance vs ground truth for illustration only
plot(mcmc_output, type = "obs_sigma_t2", true_values = noise^2)

}
