% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataFrameSubsetDS1.R
\name{dataFrameSubsetDS1}
\alias{dataFrameSubsetDS1}
\title{dataFrameSubsetDS1 an aggregate function called by ds.dataFrameSubset}
\usage{
dataFrameSubsetDS1(
  df.name = NULL,
  V1.name = NULL,
  V2.name = NULL,
  Boolean.operator.n = NULL,
  keep.cols = NULL,
  rm.cols = NULL,
  keep.NAs = NULL
)
}
\arguments{
\item{df.name}{a character string providing the name for the data.frame
to be sorted. <df.name> argument generated and passed directly to
dataFrameSubsetDS1 by ds.dataFrameSubset}

\item{V1.name}{A character string specifying the name of a subsetting vector
to which a Boolean operator will be applied to define the subset to be created.
<V1.name> argument generated and passed directly to
dataFrameSubsetDS1 by ds.dataFrameSubset}

\item{V2.name}{A character string specifying the name of the vector
or scalar to which the values in the vector specified by the argument <V1.name>
is to be compared.
<V2.name> argument generated and passed directly to
dataFrameSubsetDS1 by ds.dataFrameSubset}

\item{Boolean.operator.n}{A character string specifying one of six possible Boolean operators:
'==', '!=', '>', '>=', '<', '<='
<Boolean.operator.n> argument generated and passed directly to
dataFrameSubsetDS1 by ds.dataFrameSubset}

\item{keep.cols}{a numeric vector specifying the numbers of the columns to be kept in the
final subset when subsetting by column. For example: keep.cols=c(2:5,7,12) will keep
columns 2,3,4,5,7 and 12.
<keep.cols> argument generated and passed directly to
dataFrameSubsetDS1 by ds.dataFrameSubset}

\item{rm.cols}{a numeric vector specifying the numbers of the columns to be removed before
creating the final subset when subsetting by column. For example: rm.cols=c(2:5,7,12)
will remove columns 2,3,4,5,7 and 12.
<rm.cols> argument generated and passed directly to
dataFrameSubsetDS1 by ds.dataFrameSubset}

\item{keep.NAs}{logical, if TRUE any NAs in the vector holding the final Boolean vector
indicating whether a given row should be included in the subset will be converted into
1s and so they will be included in the subset. Such NAs could be caused by NAs in
either <V1.name> or <V2.name>. If FALSE or NULL NAs in the final Boolean vector will
be converted to 0s and the corresponding row will therefore be excluded from the subset.
<keep.NAs> argument generated and passed directly to
dataFrameSubsetDS1 by ds.dataFrameSubset}
}
\value{
This first serverside function called by ds.dataFrameSubset provides
first level traps for a comprehensive series of disclosure risks which can be
returned directly to the clientside because dataFrameSubsetDS1 is an aggregate
function. The second serverside function called by ds.dataFrameSubset
(dataFrameSubsetDS2) carries out most of the same disclosure tests, but it is
an assign function because it writes the subsetted data.frame to the serverside.
In consequence, it records error messages as studysideMessages which can only be
retrieved using ds.message
}
\description{
First serverside function for subsetting a data frame by row or by column.
}
\details{
A data frame is a list of variables all with the same number of rows,
which is of class 'data.frame'. For all details see the help header for ds.dataFrameSubset
}
\author{
Paul Burton
}
