% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplots.R
\name{doBiplot}
\alias{doBiplot}
\title{Make biplot for any type of PCA}
\usage{
doBiplot(x, choices = 1L:2L, scale = 1, pc.biplot = FALSE, col, ...)
}
\arguments{
\item{x}{output from PCA analysis.}

\item{choices}{numeric vector of length 2. Use to choose which of the PC axes to plot. Default plots first and second axes: "choices = c(1,2)".}

\item{scale}{numeric value between 0 and 1. Same as in "stats::biplot.princomp". See ?biplot.princomp for more information.}

\item{pc.biplot}{logical. If TRUE it will produce a "principal component biplot" (sensu Gabriel, 1971). Same as in "stats::biplot.princomp". See ?biplot.princomp for more information.}

\item{col}{character vector of length 3 with the colors of the biplot. First color is used for the score points (or sample sames), second color for arrows and variable names, and third color for the right and top-side ticks (plot axes).}

\item{...}{extra parameters for the function. Same as "stats::biplot".}
}
\value{
makes a biplot of the PCA results.
}
\description{
Function to make biplots for any kind of PCA. It accepts the outputs from standard PCA (princomp and prcomp). It also works with the "phylProbPCA" and "ProbPCA" functions. It provides more options to the plot than the standard "stats::biplot".
}
\details{
Function has the same options as "stats::biplot", with the addition of the following arguments. "plot_dimnames" controls is the names of the samples (species) will be plotted. "add_points" controls if the score points will be plotted. "add_margin" is a numeric value that expands the area of the plot. You can use this to make sure the names of variables and samples (species) fit the plot.
}
\examples{
phy <- ratematrix::anoles$phy[[1]]
dt <- as.matrix( ratematrix::anoles$data[,1:3] )

## Using probabilistic phylogenetic PCA
phylppca <- phylProbPCA(phy = phy, x = dt, ret_dim = 2)
doBiplot(x = phylppca, add_margin = 0.3)

## Using standard phylogenetic PCA
phylpca <- phytools::phyl.pca(tree = phy, Y = dt)
doBiplot(x = phylpca, add_margin = 0.3)

## Using probabilistic PCA
ppca <- ProbPCA(x = dt)
doBiplot(x = ppca, add_margin = 0.3)

## Using standard PCA
pca1 <- princomp(x = dt)
doBiplot(x = pca1, add_margin = 0.1)

## Using standard PCA
pca2 <- prcomp(x = dt)
doBiplot(x = pca2, add_margin = 0.1)

}
