\name{predict}
\alias{predict.dSurv}
\alias{predict.deepAFT}
\alias{predict.deepSurv}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Predicted Values for a deepAFT or a deepSurv Object
}
\description{
Compute the predicted values for a deepAFT or a deepSurv object
}
\usage{
## S3 method for class 'predict'
\method{predict}{dSurv}(object, newdata, newy=NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{the results of a model fit using the deepAFT or the deepSurv function.}
  \item{newdata}{optional new data at which to do predictions. If absent, predictions are for the dataframe used in the original fit.}
  \item{newy}{optional new outcome variable y.}
  \item{\dots}{other options used in predict().}
}
\details{
  predict.dSurv is called to predict object from a deepAFT \code{\link{deepAFT}} or a deepSurv \code{\link{deepSurv}} model.

  The default method, predict has its own help page. Use methods("predict") to get all the methods for the predict generic.
}

\value{
%%  ~Describe the value returned
predict.dSurv returns a list of the predicted values, risk scores and the cumulative hazard function. 

  \item{lp}{covariate effect predictor beta(X), wherebeta() is the fitted 
  regression function and X is the covariate matrix.}
  \item{risk}{risk score, risk = exp(-lp) for the deepAFT model and risk = exp(lp) for the deepSurv model. 
       When new y is provided, both lp and risk will be ordered by survival time of the new y.}
  \item{cumhaz}{the fitted cumulative hzard function for the training data with covariate X = 0 
        will be reported if new y is missing.}
  \item{time}{time for cumulative hazard function. Time from new y will be used if new y is provided.}
  \item{cindex}{the concordance index for the fitted model or the predicted model if new y are provided.}
  \item{c.index}{the numerical value of the cindex.}
}
\author{Bingshu E. Chen}
\seealso{
 The default method for predict \code{\link{predict}},
\code{\link{deepAFT}}, 
\code{\link{deepSurv}}, 
\code{\link{survfit.deepSurv}}
}
%\examples{}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ predict }
