% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icm_function.R
\name{compute_inter}
\alias{compute_inter}
\title{Computes Integrated Covariance Mahalanobis (ICM) distances between
batches barycenters in PCA-reduced space, using a reference bacth and either
mean or median for center references.}
\usage{
compute_inter(
  pc_data,
  batch_col,
  ref_batch,
  center_method = c("mean", "median")
)
}
\arguments{
\item{pc_data}{PCA-reduced data frame.}

\item{batch_col}{Name of the column representing batch or group.}

\item{ref_batch}{Name of the reference batch for distance computation.}

\item{center_method}{Method for centering: "mean" or "median".}
}
\value{
A data frame with Mahalanobis distances for each batch against the
reference.
}
\description{
Computes Integrated Covariance Mahalanobis (ICM) distances between
batches barycenters in PCA-reduced space, using a reference bacth and either
mean or median for center references.
}
