% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.r
\name{markerAxis}
\alias{markerAxis}
\title{Compute chromosome breakpoints and tick positions}
\usage{
markerAxis(includedSites, ChosenSites = "all", tickDist)
}
\arguments{
\item{includedSites}{BED-like file defining genomic sites, ideally output from \code{vcf2diem}.}

\item{ChosenSites}{Logical vector of sites to be analyzed.}

\item{tickDist}{Distance between tick marks along the chromosome in bp.}
}
\value{
A list containing:
\itemize{
\item \code{CHROMbreaks}: Positions of chromosome breaks.
\item \code{CHROMnamesPos}: Midpoints for chromosome labels.
\item \code{CHROMnames}: Unique chromosome names.
\item \code{ticksPos}: Positions for tick marks.
\item \code{ticksNames}: Tick labels in megabases.
}
}
\description{
Identifies chromosome breaks and calculates tick positions based on physical distances.
Used for plotting genomic axes with consistent spacing.
}
\keyword{internal}
