% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependentsim.R
\name{get_random_structure}
\alias{get_random_structure}
\title{Compute structure of dependency from a given data}
\usage{
get_random_structure(datasets, method, rank = 2, types = "normal")
}
\arguments{
\item{datasets}{A list of data matrices that we will mimic. All datasets have samples in the columns and features (e.g., genes, proteins) in the rows. All datasets must have the same samples in corresponding columns.}

\item{method}{One of 'pca', 'spiked Wishart', or 'corp.cor', for the method of determining a dependency structure}

\item{rank}{Number of PCA components to approximate the dependence structure of. Only used if method = 'pca'.}

\item{types}{The marginal distribution types ('normal', 'poisson', 'DESeq2', or 'empirical'), as a list with entries corresponding to datasets. If just a single value is provided, then it is used for all datasets.}
}
\value{
A random structure element suitable for use with draw_from_multivariate_corr().
}
\description{
Compute structure of dependency from a given data
}
\examples{
# Simple data to mimic
true_means <- c(0, 1, 10, 1000)
data <- rpois(4*12, true_means) |> matrix(4, 12)

# Simulate draws mimicking that data
rs <- get_random_structure(list(data=data), method="pca", rank=2, type="poisson")
draws <- draw_from_multivariate_corr(rs, n_samples=30)
}
