#' @keywords internal

compute_fourier <- function(f, x, a, b, eps, tau, Lmax) {
  FT_real <- numeric()
  FT_imag <- numeric()

  l <- 1
  t <- 0
  repeat {
    Ref <- (b - a) / length(x) * sum(f * cos(t * x))
    Imf <- (b - a) / length(x) * sum(f * sin(t * x))
    FTf <- Ref + (0 + 1i) * Imf

    FT_real <- c(FT_real, Ref)
    FT_imag <- c(FT_imag, Imf)

    if (abs(FTf) <= eps || l >= Lmax) {
      break
    }

    l <- l + 1
    t <- t + tau
  }

  list(real = FT_real, imag = FT_imag)
}
