% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dwc.R
\name{get_dwc}
\alias{get_dwc}
\title{Get Darwin Core Terms and Definitions}
\usage{
get_dwc(type)
}
\arguments{
\item{type}{Which type of distribution files to download. Available options are:
\itemize{
\item simple Simple Darwin Core Terms.
\item all All Darwin Core Terms.
}}
}
\value{
a list.
}
\description{
\code{get_dwc()} returns a list of standardized terms and definitions used by the Darwin Core
Maintenance Interest Group \url{https://dwc.tdwg.org/}.
}
\details{
\code{get_dwc()} reads Darwin Core distribution documents and terms from Github repository
\url{https://github.com/tdwg/dwc} directly into \code{Environment}. This function will return a list
containing the most recent accepted terms as a vector and a \link[tibble:tbl_df-class]{tbl_df} containing
terms, definitions, examples and details about each one of them.
}
\examples{
dwc <- get_dwc(type= "simple") 

}
\author{
Pedro S. Bittencourt, Rupert A. Collins
}
