% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_texts.R
\name{split_text}
\alias{split_text}
\title{Split Text into Byte-Limited Segments}
\usage{
split_text(text, max_size_bytes = 29000, tokenize = "sentences")
}
\arguments{
\item{text}{A character vector containing the text(s) to be split.}

\item{max_size_bytes}{An integer specifying the maximum size (in bytes) for each segment.}

\item{tokenize}{A string indicating the level of tokenization. Must be either \code{"sentences"} or \code{"words"}.}
}
\value{
A tibble with one row per text segment, containing the following columns:
\itemize{
  \item \code{text_id}: The index of the original text in the input vector.
  \item \code{segment_id}: A sequential ID identifying the segment number.
  \item \code{segment_text}: The resulting text segment, each within the specified byte limit.
}
}
\description{
\code{split_text} divides input text into smaller segments that do not exceed a specified maximum size in bytes.
    Segmentation is based on sentence or word boundaries.
}
\details{
This function uses \code{tokenizers::tokenize_sentences} (or \code{tokenize_words} if specified) 
    to split the text into natural language segments before assembling byte-limited blocks.
}
\examples{
\dontrun{
long_text <- paste0(rep("This is a very long text. ", 10000), collapse = "")
split_text(long_text, max_size_bytes = 1000, tokenize = "sentences")
}

}
