% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_glossary2.R
\name{delete_glossary2}
\alias{delete_glossary2}
\title{Delete a Glossary with the DeepL API Free}
\usage{
delete_glossary2(glossary_id, auth_key)
}
\arguments{
\item{glossary_id}{A string specifying the unique ID of the glossary to be deleted.}

\item{auth_key}{A string representing the authentication key for the DeepL API Free. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\value{
No return value. A confirmation message is printed upon successful deletion.
}
\description{
\code{delete_glossary2} deletes a glossary from your DeepL API Free account using its unique ID.
}
\details{
Deleting a glossary is permanent and cannot be undone. If needed, you can back up 
    glossary entries in advance using \code{\link{get_glossary_entries2}}.

    To use this function, you must obtain an authentication key by registering for a DeepL API Free account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Free}.

    For a list of available glossaries and their metadata, see \code{\link{list_glossaries2}}.
}
\examples{
\dontrun{
glossary_id <- "example-glossary-id"
delete_glossary2(glossary_id)
}
}
\references{
\href{https://developers.deepl.com/docs/api-reference/glossaries#delete-a-glossary}{DeepL API Documentation on Glossary Deletion}
}
