% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_scatterplot-layer.R
\name{add_scatterplot_layer}
\alias{add_scatterplot_layer}
\title{Add a scatterplot layer to the deckgl widget}
\usage{
add_scatterplot_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "scatterplot-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
The \code{ScatterplotLayer} takes in paired latitude and longitude coordinated points
and renders them as circles with a certain radius.
}
\examples{
data("bart_stations")

properties <- list(
  getPosition = ~lng + lat,
  getRadius = "@=Math.sqrt(exits)", #JS("data => Math.sqrt(data.exits)"),
  radiusScale = 6,
  getFillColor = "@=code === 'LF' ? 'white': 'red'", #c(255, 140, 20),
  tooltip = "{{name}}"
)

deck <- deckgl(zoom = 10.5, pitch = 35) \%>\%
  add_scatterplot_layer(data = bart_stations, properties = properties) \%>\%
  add_basemap() \%>\%
  add_control("Scatterplot Layer")

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/scatterplot-layer}
}
