% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddspls.R
\name{ddsPLS}
\alias{ddsPLS}
\title{Data-Driven Sparse Partial Least Squares}
\usage{
ddsPLS(
  X,
  Y,
  criterion = "diffR2Q2",
  doBoot = TRUE,
  LD = FALSE,
  lambdas = NULL,
  n_B = 50,
  n_lambdas = 100,
  lambda_roof = NULL,
  lowQ2 = 0,
  NCORES = 1,
  errorMin = 1e-09,
  verbose = FALSE
)
}
\arguments{
\item{X}{matrix, the covariate matrix (n,p).}

\item{Y}{matrix, the response matrix (n,q).}

\item{criterion}{character, whether \code{diffR2Q2} to be minimized, default,
or \code{Q2} to be maximized.}

\item{doBoot}{logical, whether performing bootstrap operations, default to
\code{TRUE}. If equal to
\code{FALSE}, a model with is built on the parameters \code{lambda} and the
 number of components is the length of this vector.
  In that context, the parameter \code{n_B} is ignored. If equal to
   \code{TRUE}, the ddsPLS algorithm, through bootstrap validation,
    is started using \code{lambda} as a grid and \code{n_B} as
  the total number of bootstrap samples to simulate per component.}

\item{LD}{Boolean, wether or not consider Low-Dimensional dataset.}

\item{lambdas}{vector, the to be tested values for \code{lambda}.
Each value for \code{lambda} can be interpreted in terms of correlation
 allowed in the model.
More precisely, a covariate `x[j]` is not selected if its empirical
correlation with all the response variables `y[1..q]` is below \code{lambda}.
 A response variable `y[k]` is not selected if its empirical correlation
 with all the covariates `x[1..p]` is below \code{lambda}.
Default to \code{seq(0,1,length.out = 30)}.}

\item{n_B}{integer, the number of to be simulated bootstrap samples.
Default to \code{50}.}

\item{n_lambdas}{integer, the number of lambda values. Taken into account
only if \code{lambdas} is \code{NULL}. Default to 100.}

\item{lambda_roof}{limit value to be considered in the optimization.}

\item{lowQ2}{real, the minimum value of Q^2_B to accept the
current lambda value. Default to \code{0.0}.}

\item{NCORES}{integer, the number of cores used. Default to \code{1}.}

\item{errorMin}{real, not to be used.}

\item{verbose}{boolean, whether to print current results. Defaut to
\code{FALSE}.}
}
\value{
A list with different interesting output describing the built model
}
\description{
The main function of the package. It does both start the ddsPLS algorithm,
using bootstrap analysis. Also it estimates automatically the number of
components and the regularization coefficients.
One regularization parameter per component only is needed to select both in
\code{x} and in \code{y}. Build the optimal model, of the class
\code{ddsPLS}.
Among the different parameters, the \code{lambda} is the vector of parameters that are
tested by the algorithm along each component for each bootstrap sample. The total number
of bootstrap samples is fixed by the parameter \code{n_B}, for this parameter, the more
 the merrier, even if costs more in computation time.
This gives access to 3 S3 methods (\code{\link{summary.ddsPLS}}, \code{\link{plot.ddsPLS}} and \code{\link{predict.ddsPLS}}).
}
\examples{
# n <- 100 ; d <- 2 ; p <- 20 ; q <- 2
# phi <- matrix(rnorm(n*d),n,d)
# a <- rep(1,p/4) ; b <- rep(1,p/2)
# X <- phi\%*\%matrix(c(1*a,0*a,0*b,
#                     1*a,3*b,0*a),nrow = d,byrow = TRUE) + matrix(rnorm(n*p),n,p)
# Y <- phi\%*\%matrix(c(1,0,
#                     0,0),nrow = d,byrow = TRUE) + matrix(rnorm(n*q),n,q)
# model_ddsPLS <- ddsPLS(X,Y,verbose=TRUE)

}
\seealso{
\code{\link{summary.ddsPLS}}, \code{\link{plot.ddsPLS}}, \code{\link{predict.ddsPLS}}
}
