% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcsvm.R
\name{dcsvm}
\alias{dcsvm}
\title{Density-Convoluted Support Vector Machine}
\usage{
dcsvm(
  x,
  y,
  nlambda = 100,
  lambda.factor = ifelse(nobs < nvars, 0.01, 1e-04),
  lambda = NULL,
  lam2 = 0,
  kern = c("gaussian", "uniform", "epanechnikov"),
  hval = 1,
  pf = rep(1, nvars),
  pf2 = rep(1, nvars),
  exclude,
  dfmax = nvars + 1,
  pmax = min(dfmax * 1.2, nvars),
  standardize = TRUE,
  eps = 1e-08,
  maxit = 1e+06,
  istrong = TRUE
)
}
\arguments{
\item{x}{A numeric matrix with \eqn{N} rows and \eqn{p} columns representing predictors. Each row corresponds to an observation, and each column corresponds to a variable.}

\item{y}{A numeric vector of length \eqn{N} representing binary responses. Elements must be either -1 or 1.}

\item{nlambda}{Number of \code{lambda} values in the sequence. Default is 100.}

\item{lambda.factor}{Ratio of the smallest to the largest \code{lambda} in the sequence: \code{lambda.factor} = \code{min(lambda)} / \code{max(lambda)}. The default value is 0.0001 if \eqn{N >= p} or 0.01 if \eqn{N < p}. Takes no effect if a \code{lambda} sequence is specified.}

\item{lambda}{An optional user-specified sequence of \code{lambda} values. If \code{lambda = NULL} (default), the sequence is computed based on \code{nlambda} and \code{lambda.factor}. The program automatically sorts user-defined \code{lambda} sequences in decreasing order.}

\item{lam2}{Users may tune \eqn{\lambda_2}, which controls the L2 regularization strength. Default is 0 (lasso).}

\item{kern}{Type of kernel method for smoothing. Options are \code{"gaussian"}, \code{"uniform"}, and \code{"epanechnikov"}. Default is \code{"epanechnikov"}.}

\item{hval}{The bandwidth parameter for kernel smoothing. Default is 1.}

\item{pf}{A numeric vector of length \eqn{p} representing the L1 penalty weights for each coefficient. A common choice is \eqn{(\beta + 1/n)^{-1}}, where \eqn{n} is the sample size and \eqn{\beta} is obtained from L1 DCSVM or enet DCSVM. Default is 1 for all predictors.}

\item{pf2}{A numeric vector of length \eqn{p} representing the L2 penalty weights for each coefficient. A value of 0 indicates no L2 shrinkage. Default is 1 for all predictors.}

\item{exclude}{Indices of predictors to exclude from the model. Equivalent to assigning an infinite penalty factor. Default is none.}

\item{dfmax}{Maximum number of nonzero coefficients allowed in the model. Default is \eqn{p + 1}. Useful for large \eqn{p} when a partial path is acceptable.}

\item{pmax}{Maximum number of variables allowed to ever be nonzero during the computation. Default is \code{min(dfmax * 1.2, p)}.}

\item{standardize}{Logical indicating whether predictors should be standardized to unit variance. Default is \code{TRUE}. Note that predictors are always centered.}

\item{eps}{Convergence threshold. The algorithm stops when \eqn{4\max_j(\beta_j^{new} - \beta_j^{old})^2} is less than \code{eps}. Default is \code{1e-8}.}

\item{maxit}{Maximum number of iterations allowed. Default is \code{1e6}. Consider increasing \code{maxit} if the algorithm does not converge.}

\item{istrong}{Logical indicating whether to use the strong rule for faster computation. Default is \code{TRUE}.}
}
\value{
An object of class \code{dcsvm} containing the following components:
  \item{b0}{Intercept values for each \code{lambda}.}
  \item{beta}{Sparse matrix of coefficients for each \code{lambda}. Use \code{as.matrix()} to convert.}
  \item{df}{Number of nonzero coefficients for each \code{lambda}.}
  \item{dim}{Dimensions of the coefficient matrix.}
  \item{lambda}{Sequence of \code{lambda} values used.}
  \item{npasses}{Total number of iterations across all \code{lambda} values.}
  \item{jerr}{Warnings and errors. 0 if no errors.}
  \item{call}{The matched call.}
}
\description{
Fits the density-convoluted support vector machine (DCSVM) through kernel density convolutions.
}
\examples{
# Load the data
data(colon)
# Fit the elastic-net penalized DCSVM with lambda2 to be 1
fit <- dcsvm(colon$x, colon$y, lam2 = 1)
print(fit)
# Coefficients at some lambda value
c1 <- coef(fit, s = 0.005)
# Make predictions
predict(fit, newx = colon$x[1:10, ], s = c(0.01, 0.005))

}
\seealso{
\code{print.dcsvm}, \code{predict.dcsvm}, \code{coef.dcsvm}, \code{plot.dcsvm}, and \code{cv.dcsvm}.
}
