% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_int_unexp_records_set_segment.R
\name{util_int_unexp_records_set_segment}
\alias{util_int_unexp_records_set_segment}
\title{Check for unexpected data record set}
\usage{
util_int_unexp_records_set_segment(
  level = c("segment"),
  id_vars_list,
  identifier_name_list,
  valid_id_table_list,
  meta_data_record_check_list,
  study_data,
  label_col,
  meta_data,
  item_level,
  meta_data_segment = "segment_level",
  segment_level
)
}
\arguments{
\item{level}{\link{character} a character vector indicating whether the assessment should be conducted at the study level (level = "dataframe") or at the segment level (level = "segment").}

\item{id_vars_list}{\link{list} the list containing the identifier variables names to be used in the assessment.}

\item{identifier_name_list}{\link{list} the list that contains the name of the identifier to be used in the assessment. For the study level, corresponds to the names of the different data frames. For the segment level, indicates the name of the segments.}

\item{valid_id_table_list}{\link{list} the reference list with the identifier variable values.}

\item{meta_data_record_check_list}{\link{character} a character vector indicating the type of check to conduct, either "subset" or "exact".}

\item{study_data}{\link{data.frame} the data frame that contains the measurements, mandatory.}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{meta_data}{\link{data.frame} the data frame that contains metadata attributes of the study data, mandatory.}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{segment_level}{\link{data.frame} alias for \code{meta_data_segment}}
}
\value{
a \link{list} with
\itemize{
\item \code{SegmentData}: data frame with the results of the quality check for unexpected data elements
\item \code{SegmentTable}: data frame with selected unexpected data elements check results, used for the data quality report.
\item \code{UnexpectedRecords}: vector with row indices of duplicated records, if any, otherwise NULL.
}
}
\description{
This function tests that the identifiers match a provided record set. It is possible to
check for unexpected data record sets by study segments or to consider only selected
segments.
}
\seealso{
Other integrity_indicator_functions: 
\code{\link{util_int_duplicate_content_dataframe}()},
\code{\link{util_int_duplicate_content_segment}()},
\code{\link{util_int_duplicate_ids_dataframe}()},
\code{\link{util_int_duplicate_ids_segment}()},
\code{\link{util_int_unexp_records_set_dataframe}()}
}
\concept{integrity_indicator}
\concept{integrity_indicator_functions}
\keyword{internal}
