% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{dc_get_property_values}
\alias{dc_get_property_values}
\title{Get Property Values for Data Commons Nodes}
\usage{
dc_get_property_values(
  nodes,
  properties = "name",
  api_key = Sys.getenv("DATACOMMONS_API_KEY"),
  base_url = Sys.getenv("DATACOMMONS_BASE_URL", unset =
    "https://api.datacommons.org/v2/"),
  return_type = "json"
)
}
\arguments{
\item{nodes}{A character vector of terms to resolve.}

\item{properties}{A character vector of properties (e.g. "name", "latitude",
"all")}

\item{api_key}{Your Data Commons API key. If not provided, uses the
environment variable \code{DATACOMMONS_API_KEY}.}

\item{base_url}{The base URL of the Data Commons API. Defaults to the public
endpoint. For custom deployments, must end with \verb{/core/api/v2/}.}

\item{return_type}{Return format: either \code{"list"} (parsed R object) or
\code{"json"} (JSON string).}
}
\value{
A list containing the requested property values for each node.
The structure depends on the properties requested and follows the same
format as \code{\link[=dc_get_node]{dc_get_node()}}.
}
\description{
A convenience wrapper around \code{\link[=dc_get_node]{dc_get_node()}} to retrieve all property values
for the specified nodes. This is equivalent to calling \code{\link[=dc_get_node]{dc_get_node()}} with
\code{expression = "<-"}.
}
\examples{
\dontshow{if (dc_has_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get the name property (default)
dc_get_property_values(nodes = "country/USA")

# Get a specific property
dc_get_property_values(nodes = "country/USA", properties = "latitude")

# Get multiple specific properties
dc_get_property_values(
  nodes = c("geoId/06085", "geoId/06087"),
  properties = c("name", "latitude", "longitude")
)

# Get all properties
dc_get_property_values(nodes = "PowerPlant", properties = "all")
\dontshow{\}) # examplesIf}
}
